unit Unit1;
//  .
//     
// BREAK     FOR.

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    LabelTitle: TLabel;
    Memo1: TMemo;
    Memo2: TMemo;
    ListBox1: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    procedure ListBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var  Form1: TForm1;

implementation

{$R *.dfm}

var TestArray   : array [0..15] of integer;
    TestDouble1 : double;
    TestDouble2 : double;

//  
procedure ShowArray (var RqArray  : array of integer;
                         RqReport : TMemo);
var Ind : integer;
begin
  RqReport.Lines.Add('  :');
  for Ind := Low(RqArray) to High(RqArray) do
  begin
    RqReport.Lines.Add(IntToStr(RqArray[Ind]));
  end;
end; // of procedure

//   
procedure MakeRandomArray (var RqArray  : array of integer;
                               RqRange  : integer;
                               RqReport : TMemo);
var Ind : integer;
begin
  for Ind := Low(RqArray) to High(RqArray) do
  begin
    RqArray[Ind] := 1 + Random(RqRange);
  end;
  // 
  RqReport.Lines.Add('  ');
  ShowArray( RqArray, RqReport);
end; // of procedure

//   
procedure SumArray (RqArray   : array of integer;
                var SumResult : double;
                    RqReport  : TMemo);
var Ind : integer;
begin
  SumResult := 0;
  for Ind := Low(RqArray) to High(RqArray) do
  begin
    SumResult := SumResult + RqArray[Ind];
  end;
  // 
  RqReport.Lines.Add('');
  RqReport.Lines.Add('   :');
  RqReport.Lines.Add(FloatToStr(SumResult));
end; // of procedure

//    
procedure ProdArray (RqArray   : array of integer;
                var ProdResult : double;
                    RqReport   : TMemo);
var Ind : integer;
begin
  ProdResult := 1;
  for Ind := Low(RqArray) to High(RqArray) do
  begin
    if RqArray[Ind] <> 0
    then ProdResult := ProdResult * RqArray[Ind];
  end;
  // 
  RqReport.Lines.Add('');
  RqReport.Lines.Add('   :');
  RqReport.Lines.Add(FloatToStr(ProdResult));
end; // of procedure

//   
procedure MinMaxInArray (RqArray   : array of integer;
                  var MinResult : double;
                  var MaxResult : double;
                      RqReport  : TMemo);
var Ind : integer;
begin
  MinResult := RqArray[Low(RqArray)];
  MaxResult := MinResult;
  for Ind := Low(RqArray) to High(RqArray) do
  begin
    if RqArray[Ind] < MinResult
    then MinResult := RqArray[Ind];
    if RqArray[Ind] > MaxResult
    then MaxResult := RqArray[Ind];
  end;
  // 
  RqReport.Lines.Add('');
  RqReport.Lines.Add('  :');
  RqReport.Lines.Add(FloatToStr(MinResult));
  RqReport.Lines.Add('  :');
  RqReport.Lines.Add(FloatToStr(MaxResult));
end;  // of procedure

//   ( )
procedure SortArray(var RqArray  : array of integer;
                        SortCmd  : Char;
                        RqReport : TMemo);
var TopInd : integer;
    Ind    : integer;   //  
    Buf    : integer;   //    
begin
  if Length(RqArray) > 1
  then begin
    //     
    //  
    TopInd := High(RqArray);
    repeat
       Ind := Low(RqArray);
       //   Low(RqArray)  
       //    
       //   .
       repeat
          Buf := RqArray[Ind];
          if (Ind + 1) <= TopInd
          then begin
            case UpCase(SortCmd) of
            'U': begin
                   if (RqArray[Ind + 1] > Buf)
                   then begin
                     //    
                     RqArray[Ind] := RqArray[Ind + 1];
                     //    
                     RqArray[Ind + 1] := Buf;
                   end;
                 end;
            'D': begin
                   if (RqArray[Ind + 1] < Buf)
                   then begin
                     //    
                     RqArray[Ind] := RqArray[Ind + 1];
                     //    
                     RqArray[Ind + 1] := Buf;
                   end;
                end;
            end; // of case
          end;
          Ind := Ind + 1;
        until (Ind >= TopInd );
        //       TopInd.
        //   TopInd    .
        TopInd := TopInd -1;
    until (TopInd <= Low(RqArray));
  end;
  // 
  RqReport.Lines.Add('');
  case UpCase(SortCmd) of
  'U': RqReport.Lines.Add('  ');
  'D': RqReport.Lines.Add('  ');
  end;
  ShowArray( RqArray, RqReport);
end; {of procedure}

//   
procedure ShowProcedure (RqName : string; RqReport : TMemo);
const SubDir = '.\Procedures\';
begin
   RqReport.Clear;
   if FileExists(SubDir + RqName + '.txt')
   then begin
     RqReport.Lines.LoadFromFile(SubDir + RqName + '.txt');
   end;
end; {of procedure}

procedure TForm1.ListBox1Click(Sender: TObject);
begin
   case ListBox1.ItemIndex of
   0 : begin
          Memo1.Clear;
          Memo2.Clear;
       end;
   1 : begin
          ShowProcedure('ShowArray', Memo1);
          ShowArray(TestArray, Memo2);
       end;
   2 : begin
          ShowProcedure('MakeRandomArray', Memo1);
          MakeRandomArray(TestArray, 20, Memo2);
       end;
   3 : begin
          ShowProcedure('SumArray', Memo1);
          SumArray(TestArray, TestDouble1, Memo2);
       end;
   4 : begin
          ShowProcedure('ProdArray', Memo1);
          ProdArray(TestArray, TestDouble1, Memo2);
       end;
   5 : begin
          ShowProcedure('MinMaxInArray', Memo1);
          MinMaxInArray(TestArray, TestDouble1, TestDouble2, Memo2);
       end;
   6 : begin
          ShowProcedure('SortArray', Memo1);
          SortArray(TestArray, 'D', Memo2);
       end;
   7 : begin
          ShowProcedure('SortArray', Memo1);
          SortArray(TestArray, 'U', Memo2);
       end;
   8 : begin //   
          Close; //    Form1   
       end;
   end;
end;  // of procedure

end.
